<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title" id="myModalLabel"><?php echo lang('edit_sickness_rec'); ?></h4>
        </div>
        <?php $attrib = ['data-toggle' => 'validator', 'role' => 'form'];
        echo admin_form_open_multipart('sickness_recs/edit/' . $sickness_rec->id, $attrib); ?>
        <div class="modal-body">
            <p><?= lang('enter_info'); ?></p>

            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <?= lang('animal_tag', 'animal_tag'); ?>
                        <?php echo form_input('animal_tag', $sickness_rec->animal_tag, 'class="form-control" id="animal_tag" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('animal_id', 'animal_id'); ?>
                        <?php echo form_input('animal_id', $sickness_rec->animal_id, 'class="form-control" id="animal_id" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('mother_id', 'mother_id'); ?>
                        <?php echo form_input('mother_id', $sickness_rec->mother_id, 'class="form-control" id="mother_id" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('symptoms', 'symptoms'); ?>
                        <?php echo form_input('symptoms', $sickness_rec->symptoms, 'class="form-control" id="symptoms" data-bv-notempty="true"'); ?>
                    </div>
                    
                </div>
                <div class="col-md-4">
                    
                    <div class="form-group">
                        <?= lang('diagnosis_date', 'diagnosis_date'); ?>
                        <input name="diagnosis_date" value="<?= $sickness_rec->diagnosis_date ?>" class="form-control datetime" required="required" id="diagnosis_date"/>
                    </div>
                    <div class="form-group">
                        <?= lang('weight', 'weight'); ?>
                        <?php echo form_input('weight', $sickness_rec->weight, 'class="form-control" id="weight" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('disease', 'disease'); ?>
                        <?php echo form_input('disease', $sickness_rec->disease, 'class="form-control" id="disease" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('sickness_withdrawl_period', 'sickness_withdrawl_period'); ?>
                        <?php echo form_input('sickness_withdrawl_period', $sickness_rec->sickness_withdrawl_period, 'class="form-control" id="sickness_withdrawl_period" data-bv-notempty="true"'); ?>
                    </div>
                    
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <?= lang('eew_ram', 'eew_ram'); ?>
                        <?php echo form_dropdown('eew_ram', array('eew' => lang('eew'), 'ram' => lang('ram')), $sickness_rec->eew_ram, 'class="form-control tip" id="eew_ram" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('adult_new', 'adult_new'); ?>
                        <?php echo form_dropdown('adult_new', array('adult' => lang('adult'), 'new' => lang('new')), $sickness_rec->adult_new, 'class="form-control tip" id="adult_new" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('doctor', 'doctor'); ?>
                        <?php echo form_input('doctor', $sickness_rec->doctor, 'class="form-control" id="doctor" data-bv-notempty="true"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('medication', 'medication'); ?>
                        <?php echo form_input('medication_input', '', 'class="form-control" id="medication_input" data-bv-notempty="true"'); ?>
                        <input type="hidden" id="medication" name="medication"/>
                    </div>
                    <?= lang('selected_medications', 'selected_medications'); ?>
                    <div id="result_medication"><?= $sickness_rec->medication ?></div>

                </div>
                
                <div class="form-group col-md-6 all">
                        <?= lang('image', 'image') ?>
                        <input id="image" type="file" data-browse-label="<?= lang('browse'); ?>" name="image" data-show-upload="false"
                               data-show-preview="false" accept="image/*" class="form-control-file file">
                </div>
                
                <div class="col-md-12">
                    <div class="form-group">
                        <?= lang('description', 'description'); ?>
                        <?php echo form_textarea('description', $sickness_rec->description, 'class="form-control skip" id="description" style="height:100px;"'); ?>
                    </div>
                </div>
                
            </div>
        <div class="modal-footer">
            <?php echo form_submit('edit_sickness_rec', lang('edit_sickness_rec'), 'class="btn btn-primary"'); ?>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>
<script src="<?= base_url() ?>assets/js/auto_search.js"></script>
<script type="text/javascript" charset="utf-8">
    $(document).ready(function () {
        $('#biller_logo').change(function (event) {
            var biller_logo = $(this).val();
            $('#logo-con').html('<img src="<?=base_url('assets/uploads/logos')?>/' + biller_logo + '" alt="">');
        });
    });
    auto_search('animal_tag', 'animals', 'animal_tag', '<?= admin_url('auto_search/auto_search'); ?>');
    auto_search('mother_id', 'animals', 'animal_id', '<?= admin_url('auto_search/auto_search'); ?>');
    auto_search('doctor', 'doctors', 'name', '<?= admin_url('auto_search/auto_search'); ?>');
    auto_search('symptoms', 'symptoms', 'name', '<?= admin_url('auto_search/auto_search'); ?>');
    auto_search('disease', 'diseases', 'disease', '<?= admin_url('auto_search/auto_search'); ?>');
    
    function auto_search_medication(domId, table, column, reqUrl) {
    let dom = $('#'+domId);
        dom.autocomplete({
            source: function (request, response) {
                $.ajax({
                    type: 'get',
                    url: reqUrl,
                    dataType: "json",
                    data: { term: request.term, table: table, column: column },
                    success: function (data) {
                        response(data);
                    }
                });
            },
            select: function (event, ui) {
                var l = ui.item.label;
              dom.val('');
              if($('#medication').val() == '') {
                  $('#medication').val(l)
              } else {
                $('#medication').val($('#medication').val() + ', ' + l);
              }
              $('#result_medication').text($('#medication').val());
              return false;
            }
        });
    }
    
    auto_search_medication('medication_input', 'products', 'name', '<?= admin_url('auto_search/auto_search'); ?>');
    
    
</script>
<style type="text/css">
ul.ui-autocomplete {
    z-index: 1100;
}
</style>
<?= $modal_js ?>

