<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title" id="myModalLabel"><?php echo lang('add_fodder_rec'); ?></h4>
        </div>
        <?php $attrib = ['data-toggle' => 'validator', 'role' => 'form'];
        echo admin_form_open_multipart('fodder_recs/add', $attrib); ?>
        <div class="modal-body">
            <p><?= lang('enter_info'); ?></p>
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <?= lang('slip_no', 'slip_no'); ?>
                        <?php echo form_input('slip_no', '', 'class="form-control" id="slip_no" data-bv-notempty="true"'); ?>
                    </div>
                    
                </div>
                <div class="col-md-6">
                    
                    <div class="form-group">
                        <?= lang('slip_date', 'slip_date'); ?>
                        <input name="slip_date" class="form-control datetime" required="required" id="slip_date"/>
                    </div>
                    
                </div>
                <div class="form-group col-md-12 all">
                
                    <div class="form-group">
                        <?= lang('item_name_input', 'item_name_input'); ?>
                        <?php echo form_input('item_name_input', '', 'class="form-control" id="item_name_input"'); ?>
                        <input id="item_name" name="item_name" type="hidden"/>
                    </div>
                    
                </div>
                
                <div class="col-md-12">
                            <div class="control-group table-group">
                                <label class="table-label"><?= lang('selected_fodders'); ?></label>

                                <div class="controls table-controls">
                                    <table id="product_result_table" class="table items table-striped table-bordered table-condensed table-hover sortable_table">
                                        <thead>
                                        <tr>
                                            <th class="col-md-5"><?= lang('product'); ?></th>
                                            <th class="col-md-2"><?= lang('net_unit_price'); ?></th>
                                            <th class="col-md-2"><?= lang('avl_stock'); ?></th>
                                            <th class="col-md-2"><?= lang('quantity'); ?></th>
                                            <!--<th class="col-md-1" style="!important; text-align: center;" >-->
                                            <!--    <i class="fa fa-trash-o" style="opacity:0.5; filter:alpha(opacity=50);"></i>-->
                                            <!--</th>-->
                                        </tr>
                                        </thead>
                                        <tbody></tbody>
                                        <tfoot></tfoot>
                                    </table>
                                </div>
                            </div>
                </div>
                
                <div class="form-group col-md-6 all">
                        <?= lang('image', 'image') ?>
                        <input id="image" type="file" data-browse-label="<?= lang('browse'); ?>" name="image" data-show-upload="false"
                               data-show-preview="false" accept="image/*" class="form-control-file file">
                </div>
                
                <div class="col-md-12">
                    <div class="form-group">
                        <?= lang('description', 'description'); ?>
                        <?php echo form_textarea('description', '', 'class="form-control skip" id="description" style="height:100px;"'); ?>
                    </div>
                </div>
                
            </div>


        </div>
        <div class="modal-footer">
            <?php echo form_submit('add_fodder_rec', lang('add_fodder_rec'), 'class="btn btn-primary"'); ?>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>
<script src="<?= base_url() ?>assets/js/product_table.js"></script>
<script type="text/javascript" charset="utf-8">

    var obj = {};
        
    function onchange_quantity(id) {
        var q = document.getElementById(`quantity_input_${id}`).value
        obj[`${id}`] = q;
        document.getElementById('item_name').value = JSON.stringify(obj);
    }

    $(document).ready(function () {
        $('#biller_logo').change(function (event) {
            var biller_logo = $(this).val();
            $('#logo-con').html('<img src="<?=base_url('assets/uploads/logos')?>/' + biller_logo + '" alt="">');
        });
        
        function auto_search(domId, table, column, reqUrl) {
        let dom = $('#'+domId);
            dom.autocomplete({
                source: function (request, response) {
                    $.ajax({
                        type: 'get',
                        url: reqUrl,
                        dataType: "json",
                        data: { term: request.term, table: table, column: column },
                        success: function (data) {
                            response(data);
                        }
                    });
                },
                select: function (event, ui) {
                    var l = ui.item.label;
                    var data = ui.item.data;
                    var q_input = `<input id="quantity_input_${data.id}" type="number" min="1" value="0" onkeyup="onchange_quantity(${data.id})" onchange="onchange_quantity(${data.id})"/>`
                    dom.val('');
                    addRow('product_result_table', 1, [l, data.cost, data.quantity, q_input]);
                    return false;
                }
            });
        }
        
        auto_search('item_name_input', 'products', 'name', '<?= admin_url('auto_search/auto_search'); ?>')
    });
    
</script>
<style type="text/css">
ul.ui-autocomplete {
    z-index: 1100;
}
</style>
<?= $modal_js ?>
