<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title" id="myModalLabel"><?php echo lang('edit_doctor'); ?></h4>
        </div>
        <?php $attrib = ['data-toggle' => 'validator', 'role' => 'form'];
        echo admin_form_open_multipart('doctors/edit/' . $doctor->id, $attrib); ?>
        <div class="modal-body">
            <p><?= lang('enter_info'); ?></p>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <?= lang('doctor_id', 'doctor_id'); ?>
                        <?php echo form_input('doctor_id', $doctor->doctor_id, 'class="form-control tip" id="doctor_id" required="required"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('new_doctor_id', 'new_doctor_id'); ?>
                        <?php echo form_input('new_doctor_id', $doctor->new_doctor_id, 'class="form-control tip" id="new_doctor_id" required="required"'); ?>
                    </div>
                    <div class="form-group person">
                        <?= lang('title', 'title'); ?>
                        <?php echo form_input('title', $doctor->title, 'class="form-control tip" id="title" required="required"'); ?>
                    </div>
                    <div class="form-group person">
                        <?= lang('name', 'name'); ?>
                        <?php echo form_input('name', $doctor->name, 'class="form-control tip" id="name" required="required"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('clinic_name', 'clinic_name'); ?>
                        <?php echo form_input('clinic_name', $doctor->clinic_name, 'class="form-control" id="clinic_name"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('emrites_id', 'emrites_id'); ?>
                        <?php echo form_input('emrites_id', $doctor->emrites_id, 'class="form-control" id="emrites_id"'); ?>
                    </div>
                    
                </div>
                <div class="col-md-6">
                    
                    
                    <div class="form-group">
                        <?= lang('email_address', 'email_address'); ?>
                        <input type="email" name="email" class="form-control" required="required" id="email_address"
                               value="<?= $doctor->email ?>"/>
                    </div>
                    <div class="form-group">
                        <?= lang('phone', 'phone'); ?>
                        <input type="tel" name="phone" class="form-control" required="required" id="phone"
                               value="<?= $doctor->phone ?>"/>
                    </div>
                    <div class="form-group">
                        <?= lang('mobile', 'mobile'); ?>
                        <input type="tel" name="mobile" class="form-control" required="required" id="mobile"
                               value="<?= $doctor->mobile ?>"/>
                    </div>
                    <div class="form-group">
                        <?= lang('fax', 'fax'); ?>
                        <?php echo form_input('fax', $doctor->fax, 'class="form-control" id="fax" required="required"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('address', 'address'); ?>
                        <?php echo form_input('address', $doctor->address, 'class="form-control" id="address" required="required"'); ?>
                    </div>
                    <div class="form-group">
                        <?= lang('city', 'city'); ?>
                        <?php echo form_input('city', $doctor->city, 'class="form-control" id="city" required="required"'); ?>
                    </div>

                </div>
                

        </div>
        <div class="modal-footer">
            <?php echo form_submit('edit_doctor', lang('edit_doctor'), 'class="btn btn-primary"'); ?>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>
<script type="text/javascript" charset="utf-8">
    $(document).ready(function () {
        $('#biller_logo').change(function (event) {
            var biller_logo = $(this).val();
            $('#logo-con').html('<img src="<?=base_url('assets/uploads/logos')?>/' + biller_logo + '" alt="">');
        });
    });
</script>
<?= $modal_js ?>

