<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Sickness_recs_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function addSickness_recs($data = [])
    {
        if ($this->db->insert_batch('sickness_recs', $data)) {
            return true;
        }
        return false;
    }

    public function addSickness_rec($data = [])
    {
        if ($this->db->insert('sickness_recs', $data)) {
            $cid = $this->db->insert_id();
            return $cid;
        }
        return false;
    }

    public function deleteSickness_rec($id)
    {
        if ($this->db->delete('sickness_recs', ['id' => $id])) {
            return true;
        }
        return false;
    }

    public function getSickness_recByEmail($email)
    {
        $q = $this->db->get_where('sickness_recs', ['email' => $email], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getSickness_recByID($id)
    {
        $q = $this->db->get_where('sickness_recs', ['id' => $id], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function updateSickness_rec($id, $data = [])
    {
        $this->db->where('id', $id);
        if ($this->db->update('sickness_recs', $data)) {
            return true;
        }
        return false;
    }

}
