<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Mortality_recs_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function addMortality_recs($data = [])
    {
        if ($this->db->insert_batch('mortality_recs', $data)) {
            return true;
        }
        return false;
    }

    public function addMortality_rec($data = [])
    {
        if ($this->db->insert('mortality_recs', $data)) {
            $cid = $this->db->insert_id();
            return $cid;
        }
        return false;
    }

    public function deleteMortality_rec($id)
    {
        if ($this->db->delete('mortality_recs', ['id' => $id])) {
            return true;
        }
        return false;
    }

    public function getMortality_recByEmail($email)
    {
        $q = $this->db->get_where('mortality_recs', ['email' => $email], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getMortality_recByID($id)
    {
        $q = $this->db->get_where('mortality_recs', ['id' => $id], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function updateMortality_rec($id, $data = [])
    {
        $this->db->where('id', $id);
        if ($this->db->update('mortality_recs', $data)) {
            return true;
        }
        return false;
    }

}
