<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Db_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getBestSeller($start_date = null, $end_date = null)
    {
        if (!$start_date) {
            $start_date = date('Y-m-d', strtotime('first day of this month')) . ' 00:00:00';
        }
        if (!$end_date) {
            $end_date = date('Y-m-d', strtotime('last day of this month')) . ' 23:59:59';
        }

        $this->db
            ->select('product_name, product_code')
            ->select_sum('quantity')
            ->from('sale_items')
            ->join('sales', 'sales.id = sale_items.sale_id', 'left')
            ->where('date >=', $start_date)
            ->where('date <', $end_date)
            ->group_by('product_name, product_code')
            ->order_by('sum(quantity)', 'desc')
            ->limit(10);
        $q = $this->db->get();
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getChartData()
    {
        $myQuery = "SELECT S.month,
        COALESCE(S.sales, 0) as sales,
        COALESCE( P.purchases, 0 ) as purchases,
        COALESCE(S.tax1, 0) as tax1,
        COALESCE(S.tax2, 0) as tax2,
        COALESCE( P.ptax, 0 ) as ptax
        FROM (  SELECT  date_format(date, '%Y-%m') Month,
                SUM(total) Sales,
                SUM(product_tax) tax1,
                SUM(order_tax) tax2
                FROM " . $this->db->dbprefix('sales') . "
                WHERE date >= date_sub( now( ) , INTERVAL 12 MONTH )
                GROUP BY date_format(date, '%Y-%m')) S
            LEFT JOIN ( SELECT  date_format(date, '%Y-%m') Month,
                        SUM(product_tax) ptax,
                        SUM(order_tax) otax,
                        SUM(total) purchases
                        FROM " . $this->db->dbprefix('purchases') . "
                        GROUP BY date_format(date, '%Y-%m')) P
            ON S.Month = P.Month
            ORDER BY S.Month";
        $q = $this->db->query($myQuery);
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return false;
    }

    public function getLastestQuotes()
    {
        if ($this->Settings->restrict_user && !$this->Owner && !$this->Admin) {
            $this->db->where('created_by', $this->session->userdata('user_id'));
        }
        $this->db->order_by('id', 'desc');
        $q = $this->db->get('quotes', 5);
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function getLatestCustomers()
    {
        $this->db->order_by('id', 'desc');
        $q = $this->db->get_where('companies', ['group_name' => 'customer'], 5);
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function getLatestPurchases()
    {
        if ($this->Settings->restrict_user && !$this->Owner && !$this->Admin) {
            $this->db->where('created_by', $this->session->userdata('user_id'));
        }
        $this->db->order_by('id', 'desc');
        $q = $this->db->get('purchases', 5);
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function getLatestSales()
    {
        if ($this->Settings->restrict_user && !$this->Owner && !$this->Admin) {
            $this->db->where('created_by', $this->session->userdata('user_id'));
        }
        $this->db->order_by('id', 'desc');
        $q = $this->db->get('sales', 5);
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function getLatestSuppliers()
    {
        $this->db->order_by('id', 'desc');
        $q = $this->db->get_where('companies', ['group_name' => 'supplier'], 5);
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function getLatestTransfers()
    {
        if ($this->Settings->restrict_user && !$this->Owner && !$this->Admin) {
            $this->db->where('created_by', $this->session->userdata('user_id'));
        }
        $this->db->order_by('id', 'desc');
        $q = $this->db->get('transfers', 5);
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function getStockValue()
    {
        $q = $this->db->query('SELECT SUM(qty*price) as stock_by_price, SUM(qty*cost) as stock_by_cost
        FROM (
            Select sum(COALESCE(' . $this->db->dbprefix('warehouses_products') . '.quantity, 0)) as qty, price, cost
            FROM ' . $this->db->dbprefix('products') . '
            JOIN ' . $this->db->dbprefix('warehouses_products') . ' ON ' . $this->db->dbprefix('warehouses_products') . '.product_id=' . $this->db->dbprefix('products') . '.id
            GROUP BY ' . $this->db->dbprefix('warehouses_products') . '.id ) a');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }
    
    
    
    public function getLatest_fodder_recs()
    {
        $this->db->order_by('id', 'desc');
        $q = $this->db->get('fodder_recs', 5);
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
    }
    
    public function getLatest_medicine_recs()
    {
        $this->db->order_by('id', 'desc');
        $q = $this->db->get('medicine_recs', 5);
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
    }
    
    public function get_live_animals()
    {
        $q = $this->db->get_where('animals', ['live_dead' => 'live']);
        return $q->num_rows();
    }
    public function get_dead_animals()
    {
        $q = $this->db->get_where('animals', ['live_dead' => 'dead']);
        return $q->num_rows();
    }
    public function get_sick_animals()
    {
        return $this->db->count_all('sickness_recs');
    }
    public function get_mortalities()
    {
        return $this->db->count_all('mortality_recs');
    }
    public function get_new_borns()
    {
        $q = $this->db->get();
        $this->db->select('animal_id');
        $q = $this->db->get('born_recs');
        $d = $q->result_array();
        $n = 0;
        
            foreach ($d as $row) {
                $n += count(explode(",", $row['animal_id']));
            }
        
        return $n;
    }
    public function get_singles()
    {
        $q = $this->db->get();
        $this->db->select('animal_id');
        $q = $this->db->get('born_recs');
        $d = $q->result_array();
        $n = 0;
        
            foreach ($d as $row) {
                if(count(explode(",", $row['animal_id'])) == 1) $n++;
            }
        
        return $n;
    }
    public function get_twins()
    {
        $q = $this->db->get();
        $this->db->select('animal_id');
        $q = $this->db->get('born_recs');
        $d = $q->result_array();
        $n = 0;
        
            foreach ($d as $row) {
                if(count(explode(",", $row['animal_id'])) == 2) $n++;
            }
        
        return $n;
    }
    public function get_triplets()
    {
        $q = $this->db->get();
        $this->db->select('animal_id');
        $q = $this->db->get('born_recs');
        $d = $q->result_array();
        $n = 0;
        
            foreach ($d as $row) {
                if(count(explode(",", $row['animal_id'])) == 3) $n++;
            }
        
        return $n;
    }
    public function get_quadruplets()
    {
        $q = $this->db->get();
        $this->db->select('animal_id');
        $q = $this->db->get('born_recs');
        $d = $q->result_array();
        $n = 0;
        
            foreach ($d as $row) {
                if(count(explode(",", $row['animal_id'])) == 4) $n++;
            }
        
        return $n;
    }
    
    private function count_records($month, $year, $table, $date_column) {
        
        // SQL query to get count of records for given month and year
        $this->db->select('*');
        $this->db->from($table);
        // $this->db->where('MONTH('. $date_column .')', $month);
        // $this->db->where('YEAR('. $date_column .')', $year);
        $this->db->like($date_column, $month.'/'.$year);
        $query = $this->db->get();
        
        // Return the count of records
        return $query->num_rows();
    }
    
    public function get_last_12_months_animals()
    {
       $data = array();
       
       for ($i = 11; $i >= 0; $i--) {
           $year = date("Y", strtotime( date( 'Y-m-01' )." -$i months"));
           $month = date("m", strtotime( date( 'Y-m-01' )." -$i months"));
           $count = $this->count_records($month, $year, 'animals', 'purchase_date');
           if($count >= 0) {
               $data[$year."-".$month] = $count;
           }
       }
       
       return $data;
    }
    public function get_last_12_months_born_recs()
    {
        $data = array();
       
       for ($i = 11; $i >= 0; $i--) {
           $year = date("Y", strtotime( date( 'Y-m-01' )." -$i months"));
           $month = date("m", strtotime( date( 'Y-m-01' )." -$i months"));
          $count = $this->count_records($month, $year, 'born_recs', 'dob');
          if($count >= 0) {
               $data[$year."-".$month] = $count;
          }
       }
       
       return $data;
    }
    public function get_last_12_months_mortality_recs()
    {
        $data = array();
       
       for ($i = 11; $i >= 0; $i--) {
           $year = date("Y", strtotime( date( 'Y-m-01' )." -$i months"));
           $month = date("m", strtotime( date( 'Y-m-01' )." -$i months"));
          $count = $this->count_records($month, $year, 'mortality_recs', 'date_of_death');
          if($count >= 0) {
               $data[$year."-".$month] = $count;
          }
       }
       
       return $data;
    }
    public function get_last_12_months_sickness_recs()
    {
        $data = array();
       
       for ($i = 11; $i >= 0; $i--) {
           $year = date("Y", strtotime( date( 'Y-m-01' )." -$i months"));
           $month = date("m", strtotime( date( 'Y-m-01' )." -$i months"));
          $count = $this->count_records($month, $year, 'sickness_recs', 'diagnosis_date');
          if($count >= 0) {
               $data[$year."-".$month] = $count;
          }
       }
       
       return $data;
    }
}
