<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Sickness_recs extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }
        if (!$this->Owner) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }
        $this->load->library('upload');
        $this->lang->admin_load('sickness_recs', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('sickness_recs_model');
    }

    public function add()
    {
        $this->sma->checkPermissions(false, true);

        if ($this->form_validation->run('sickness_recs/add') == true) {
            $data = [
                'animal_id' => $this->input->post('animal_id'),
                            'animal_tag' => $this->input->post('animal_tag'),
                            'mother_id' => $this->input->post('mother_id'),
                            'symptoms' => $this->input->post('symptoms'),
                            'diagnosis_date' => $this->input->post('diagnosis_date'),
                            'weight' => $this->input->post('weight'),
                            'disease' => $this->input->post('disease'),
                            'sickness_withdrawl_period' => $this->input->post('sickness_withdrawl_period'),
                            'eew_ram' => $this->input->post('eew_ram'),
                            'adult_new' => $this->input->post('adult_new'),
                            'doctor' => $this->input->post('doctor'),
                            'medication' => $this->input->post('medication'),
                            'description' => $this->input->post('description'),
            ];
            
            if ($_FILES['image']['size'] > 0) {
                $config['upload_path']   = 'assets/uploads/';
                $config['allowed_types'] = 'gif|jpg|png'; 
                 $config['max_size']      = 1024; 
                //  $config['max_width']     = 1024; 
                //  $config['max_height']    = 768;  
                $config['overwrite']     = false;
                $config['max_filename']  = 25;
                $config['encrypt_name']  = true;
                // $this->load->library('upload', $config);
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('image')) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect('sickness_recs/index');
                }
                $photo         = $this->upload->file_name;
                $data['image'] = $photo;
                
            }
        } elseif ($this->input->post('add_sickness_rec')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('sickness_recs');
        }

        if ($this->form_validation->run() == true && $this->sickness_recs_model->addSickness_rec($data)) {
            $this->session->set_flashdata('message', $this->lang->line('sickness_rec_added'));
            admin_redirect('sickness_recs');
        } else {
            $this->data['logos']    = $this->getLogoList();
            $this->data['error']    = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'sickness_recs/add', $this->data);
        }
    }

    public function sickness_rec_actions()
    {
        if (!$this->Owner && !$this->GP['bulk_actions']) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }

        $this->form_validation->set_rules('form_action', lang('form_action'), 'required');

        if ($this->form_validation->run() == true) {
            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    $this->sma->checkPermissions('delete');
                    $error = false;
                    foreach ($_POST['val'] as $id) {
                        if (!$this->sickness_recs_model->deleteSickness_rec($id)) {
                            $error = true;
                        }
                    }
                    if ($error) {
                        $this->session->set_flashdata('warning', lang('sickness_recs_x_deleted_have_sales'));
                    } else {
                        $this->session->set_flashdata('message', $this->lang->line('sickness_recs_deleted'));
                    }
                    redirect($_SERVER['HTTP_REFERER']);
                }

                if ($this->input->post('form_action') == 'export_excel') {
                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('sickness_recs'));
                        $this->excel->getActiveSheet()->SetCellValue('A1', lang('animal_id'));
                        $this->excel->getActiveSheet()->SetCellValue('B1', lang('animal_tag'));
                        $this->excel->getActiveSheet()->SetCellValue('C1', lang('mother_id'));
                        $this->excel->getActiveSheet()->SetCellValue('D1', lang('symptoms'));
                        $this->excel->getActiveSheet()->SetCellValue('E1', lang('diagnosis_date'));
                        $this->excel->getActiveSheet()->SetCellValue('F1', lang('weight'));
                        $this->excel->getActiveSheet()->SetCellValue('G1', lang('disease'));
                        $this->excel->getActiveSheet()->SetCellValue('H1', lang('sickness_withdrawl_period'));
                        $this->excel->getActiveSheet()->SetCellValue('I1', lang('eew_ram'));
                        $this->excel->getActiveSheet()->SetCellValue('J1', lang('adult_new'));
                        $this->excel->getActiveSheet()->SetCellValue('K1', lang('doctor'));
                        $this->excel->getActiveSheet()->SetCellValue('L1', lang('medication'));
                        $this->excel->getActiveSheet()->SetCellValue('M1', lang('description'));
                    
                    

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $obj = $this->sickness_recs_model->getSickness_recByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $obj->animal_id);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $obj->animal_tag);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $obj->mother_id);
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, $obj->symptoms);
                        $this->excel->getActiveSheet()->SetCellValue('E' . $row, $obj->diagnosis_date);
                        $this->excel->getActiveSheet()->SetCellValue('F' . $row, $obj->weight);
                        $this->excel->getActiveSheet()->SetCellValue('G' . $row, $obj->disease);
                        $this->excel->getActiveSheet()->SetCellValue('H' . $row, $obj->sickness_withdrawl_period);
                        $this->excel->getActiveSheet()->SetCellValue('I' . $row, $obj->eew_ram);
                        $this->excel->getActiveSheet()->SetCellValue('J' . $row, $obj->adult_new);
                        $this->excel->getActiveSheet()->SetCellValue('K' . $row, $obj->doctor);
                        $this->excel->getActiveSheet()->SetCellValue('L' . $row, $obj->medication);
                        $this->excel->getActiveSheet()->SetCellValue('M' . $row, $obj->description);
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical('center');
                    $filename = 'sickness_recs_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', $this->lang->line('no_sickness_rec_selected'));
                redirect($_SERVER['HTTP_REFERER']);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public function delete($id = null)
    {
        $this->sma->checkPermissions(null, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }
        if (!$id) {
            $this->sma->send_json(['error' => 1, 'msg' => lang('id_not_found')]);
        }

        if ($this->sickness_recs_model->deleteSickness_rec($id)) {
            $this->sma->send_json(['error' => 0, 'msg' => lang('sickness_rec_deleted')]);
        } else {
            $this->sma->send_json(['error' => 1, 'msg' => lang('sickness_rec_x_deleted_have_sales')]);
        }
    }

    public function edit($id = null)
    {
        $this->sma->checkPermissions(false, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $sickness_rec_details = $this->sickness_recs_model->getSickness_recByID($id);

        if ($this->form_validation->run('sickness_recs/add') == true) {
            
            $data = [
                'animal_id' => $this->input->post('animal_id'),
                            'animal_tag' => $this->input->post('animal_tag'),
                            'mother_id' => $this->input->post('mother_id'),
                            'symptoms' => $this->input->post('symptoms'),
                            'diagnosis_date' => $this->input->post('diagnosis_date'),
                            'weight' => $this->input->post('weight'),
                            'disease' => $this->input->post('disease'),
                            'sickness_withdrawl_period' => $this->input->post('sickness_withdrawl_period'),
                            'eew_ram' => $this->input->post('eew_ram'),
                            'adult_new' => $this->input->post('adult_new'),
                            'doctor' => $this->input->post('doctor'),
                            'medication' => $this->input->post('medication'),
                            'description' => $this->input->post('description'),
            ];
            
            if ($_FILES['image']['size'] > 0) {
                $config['upload_path']   = 'assets/uploads/';
                $config['allowed_types'] = 'gif|jpg|png'; 
                 $config['max_size']      = 1024; 
                //  $config['max_width']     = 1024; 
                //  $config['max_height']    = 768;  
                // $config['overwrite']     = true;
                // $config['file_name'] = $sickness_rec_details->image;
                
                $config['overwrite']     = false;
                $config['max_filename']  = 25;
                $config['encrypt_name']  = true;
                
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('image')) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect('sickness_recs/index');
                }
                $photo         = $this->upload->file_name;
                $data['image'] = $photo;
                
            }
            
        } elseif ($this->input->post('edit_sickness_rec')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('sickness_recs');
        }

        if ($this->form_validation->run() == true && $this->sickness_recs_model->updateSickness_rec($id, $data)) {
            $this->session->set_flashdata('message', $this->lang->line('sickness_rec_updated'));
            admin_redirect('sickness_recs');
        } else {
            $this->data['sickness_rec']   = $sickness_rec_details;
            $this->data['error']    = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['logos']    = $this->getLogoList();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'sickness_recs/edit', $this->data);
        }
    }

    public function getSickness_rec($id = null)
    {
        $this->sma->checkPermissions('index');

        $row = $this->sickness_recs_model->getSickness_recByID($id);
        $this->sma->send_json([['id' => $row->id, 'text' => $row->name]]);
    }

    public function getSickness_recs()
    {
        $this->sma->checkPermissions('index');

        $this->load->library('datatables');
        $this->datatables
            ->select('id, image,  animal_id, animal_tag, mother_id, symptoms, diagnosis_date, weight, disease, sickness_withdrawl_period, eew_ram, adult_new, doctor, medication')
            ->from('sickness_recs')
            ->add_column('Actions', "<div class=\"text-center\"><a class=\"tip\" title='" . $this->lang->line('edit_sickness_rec') . "' href='" . admin_url('sickness_recs/edit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . $this->lang->line('delete_sickness_rec') . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('sickness_recs/delete/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", 'id');
        //->unset_column('id');
        echo $this->datatables->generate();
    }

    public function getLogoList()
    {
        $this->load->helper('directory');
        $dirname = 'assets/uploads/logos';
        $ext     = ['jpg', 'png', 'jpeg', 'gif'];
        $files   = [];
        if ($handle = opendir($dirname)) {
            while (false !== ($file = readdir($handle))) {
                for ($i = 0; $i < sizeof($ext); $i++) {
                    if (stristr($file, '.' . $ext[$i])) { //NOT case sensitive: OK with JpeG, JPG, ecc.
                        $files[] = $file;
                    }
                }
            }
            closedir($handle);
        }
        sort($files);
        return $files;
    }

    public function index($action = null)
    {
        $this->sma->checkPermissions();

        $this->data['error']  = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['action'] = $action;
        $bc                   = [['link' => base_url(), 'page' => lang('home')], ['link' => '#', 'page' => lang('sickness_recs')]];
        $meta                 = ['page_title' => lang('sickness_recs'), 'bc' => $bc];
        $this->page_construct('sickness_recs/index', $meta, $this->data);
    }

    public function suggestions($term = null, $limit = null)
    {
        $this->sma->checkPermissions('index');

        if ($this->input->get('term')) {
            $term = $this->input->get('term', true);
        }
        $term            = addslashes($term);
        $limit           = $this->input->get('limit', true);
        $rows['results'] = $this->sickness_recs_model->getSickness_recSuggestions($term, $limit);
        $this->sma->send_json($rows);
    }
    
    public function modal_view($id = null)
    {
        $this->sma->checkPermissions('index', true);

        $pr_details = $this->sickness_recs_model->getSickness_recByID($id);
        
        if (!$id || !$pr_details) {
            $this->session->set_flashdata('error', lang('sickness_rec_not_found'));
            $this->sma->md();
        }
        
        $this->data['sickness_rec']     = $pr_details;

        $this->load->view($this->theme . 'sickness_recs/modal_view', $this->data);
    }
    
    public function pdf($id = null, $view = null)
    {
        $this->sma->checkPermissions('index');

        $pr_details = $this->sickness_recs_model->getSickness_recByID($id);
        if (!$id || !$pr_details) {
            $this->session->set_flashdata('error', lang('prduct_not_found'));
            redirect($_SERVER['HTTP_REFERER']);
        }
        
        $this->data['sickness_rec'] = $pr_details;

        $name = lang('sickness_rec') . '_' . $pr_details->id  . '.pdf';
        if ($view) {
            $this->load->view($this->theme . 'sickness_recs/pdf', $this->data);
        } else {
            $html = $this->load->view($this->theme . 'sickness_recs/pdf', $this->data, true);
            if (!$this->Settings->barcode_img) {
                $html = preg_replace("'\<\?xml(.*)\?\>'", '', $html);
            }
            $this->sma->generate_pdf($html, $name);
        }
    }

}
