<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Mortality_recs extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }
        if (!$this->Owner) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }
        $this->load->library('upload');
        $this->lang->admin_load('mortality_recs', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('mortality_recs_model');
    }

    public function add()
    {
        $this->sma->checkPermissions(false, true);

        if ($this->form_validation->run('mortality_recs/add') == true) {
            $data = [
                'animal_id' => $this->input->post('animal_id'),
                            'animal_tag' => $this->input->post('animal_tag'),
                            'mother_id' => $this->input->post('mother_id'),
                            'date_of_death' => $this->input->post('date_of_death'),
                            'age_of_death' => $this->input->post('age_of_death'),
                            'death_reason' => $this->input->post('death_reason'),
                            'eew_ram' => $this->input->post('eew_ram'),
                            'adult_new' => $this->input->post('adult_new'),
                            'doctor' => $this->input->post('doctor'),
                            'description' => $this->input->post('description'),
            ];
            
            if ($_FILES['image']['size'] > 0) {
                $config['upload_path']   = 'assets/uploads/';
                $config['allowed_types'] = 'gif|jpg|png'; 
                 $config['max_size']      = 1024; 
                //  $config['max_width']     = 1024; 
                //  $config['max_height']    = 768;  
                $config['overwrite']     = false;
                $config['max_filename']  = 25;
                $config['encrypt_name']  = true;
                // $this->load->library('upload', $config);
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('image')) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect('mortality_recs/index');
                }
                $photo         = $this->upload->file_name;
                $data['image'] = $photo;
                
            }
        } elseif ($this->input->post('add_mortality_rec')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('mortality_recs');
        }

        if ($this->form_validation->run() == true && $this->mortality_recs_model->addMortality_rec($data)) {
            $this->session->set_flashdata('message', $this->lang->line('mortality_rec_added'));
            admin_redirect('mortality_recs');
        } else {
            $this->data['logos']    = $this->getLogoList();
            $this->data['error']    = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'mortality_recs/add', $this->data);
        }
    }

    public function mortality_rec_actions()
    {
        if (!$this->Owner && !$this->GP['bulk_actions']) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }

        $this->form_validation->set_rules('form_action', lang('form_action'), 'required');

        if ($this->form_validation->run() == true) {
            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    $this->sma->checkPermissions('delete');
                    $error = false;
                    foreach ($_POST['val'] as $id) {
                        if (!$this->mortality_recs_model->deleteMortality_rec($id)) {
                            $error = true;
                        }
                    }
                    if ($error) {
                        $this->session->set_flashdata('warning', lang('mortality_recs_x_deleted_have_sales'));
                    } else {
                        $this->session->set_flashdata('message', $this->lang->line('mortality_recs_deleted'));
                    }
                    redirect($_SERVER['HTTP_REFERER']);
                }

                if ($this->input->post('form_action') == 'export_excel') {
                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('mortality_recs'));
                        $this->excel->getActiveSheet()->SetCellValue('A1', lang('animal_id'));
                        $this->excel->getActiveSheet()->SetCellValue('B1', lang('animal_tag'));
                        $this->excel->getActiveSheet()->SetCellValue('C1', lang('mother_id'));
                        $this->excel->getActiveSheet()->SetCellValue('D1', lang('date_of_death'));
                        $this->excel->getActiveSheet()->SetCellValue('E1', lang('age_of_death'));
                        $this->excel->getActiveSheet()->SetCellValue('F1', lang('death_reason'));
                        $this->excel->getActiveSheet()->SetCellValue('G1', lang('eew_ram'));
                        $this->excel->getActiveSheet()->SetCellValue('H1', lang('adult_new'));
                        $this->excel->getActiveSheet()->SetCellValue('I1', lang('doctor'));
                        $this->excel->getActiveSheet()->SetCellValue('J1', lang('description'));
                    
                    

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $obj = $this->mortality_recs_model->getMortality_recByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $obj->animal_id);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $obj->animal_tag);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $obj->mother_id);
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, $obj->date_of_death);
                        $this->excel->getActiveSheet()->SetCellValue('E' . $row, $obj->age_of_death);
                        $this->excel->getActiveSheet()->SetCellValue('F' . $row, $obj->death_reason);
                        $this->excel->getActiveSheet()->SetCellValue('G' . $row, $obj->eew_ram);
                        $this->excel->getActiveSheet()->SetCellValue('H' . $row, $obj->adult_new);
                        $this->excel->getActiveSheet()->SetCellValue('I' . $row, $obj->doctor);
                        $this->excel->getActiveSheet()->SetCellValue('J' . $row, $obj->description);
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical('center');
                    $filename = 'mortality_recs_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', $this->lang->line('no_mortality_rec_selected'));
                redirect($_SERVER['HTTP_REFERER']);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public function delete($id = null)
    {
        $this->sma->checkPermissions(null, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }
        if (!$id) {
            $this->sma->send_json(['error' => 1, 'msg' => lang('id_not_found')]);
        }

        if ($this->mortality_recs_model->deleteMortality_rec($id)) {
            $this->sma->send_json(['error' => 0, 'msg' => lang('mortality_rec_deleted')]);
        } else {
            $this->sma->send_json(['error' => 1, 'msg' => lang('mortality_rec_x_deleted_have_sales')]);
        }
    }

    public function edit($id = null)
    {
        $this->sma->checkPermissions(false, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $mortality_rec_details = $this->mortality_recs_model->getMortality_recByID($id);

        if ($this->form_validation->run('mortality_recs/add') == true) {
            
            $data = [
                            'animal_id' => $this->input->post('animal_id'),
                            'animal_tag' => $this->input->post('animal_tag'),
                            'mother_id' => $this->input->post('mother_id'),
                            'date_of_death' => $this->input->post('date_of_death'),
                            'age_of_death' => $this->input->post('age_of_death'),
                            'death_reason' => $this->input->post('death_reason'),
                            'eew_ram' => $this->input->post('eew_ram'),
                            'adult_new' => $this->input->post('adult_new'),
                            'doctor' => $this->input->post('doctor'),
                            'description' => $this->input->post('description'),
            ];
            
            if ($_FILES['image']['size'] > 0) {
                $config['upload_path']   = 'assets/uploads/';
                $config['allowed_types'] = 'gif|jpg|png'; 
                 $config['max_size']      = 1024; 
                //  $config['max_width']     = 1024; 
                //  $config['max_height']    = 768;  
                // $config['overwrite']     = true;
                // $config['file_name'] = $mortality_rec_details->image;
                
                $config['overwrite']     = false;
                $config['max_filename']  = 25;
                $config['encrypt_name']  = true;
                
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('image')) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect('mortality_recs/index');
                }
                $photo         = $this->upload->file_name;
                $data['image'] = $photo;
                
            }
            
        } elseif ($this->input->post('edit_mortality_rec')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('mortality_recs');
        }

        if ($this->form_validation->run() == true && $this->mortality_recs_model->updateMortality_rec($id, $data)) {
            $this->session->set_flashdata('message', $this->lang->line('mortality_rec_updated'));
            admin_redirect('mortality_recs');
        } else {
            $this->data['mortality_rec']   = $mortality_rec_details;
            $this->data['error']    = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['logos']    = $this->getLogoList();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'mortality_recs/edit', $this->data);
        }
    }

    public function getMortality_rec($id = null)
    {
        $this->sma->checkPermissions('index');

        $row = $this->mortality_recs_model->getMortality_recByID($id);
        $this->sma->send_json([['id' => $row->id, 'text' => $row->name]]);
    }

    public function getMortality_recs()
    {
        $this->sma->checkPermissions('index');

        $this->load->library('datatables');
        $this->datatables
            ->select('id, image, animal_id, animal_tag, mother_id, date_of_death, age_of_death, death_reason, eew_ram, adult_new, doctor')
            ->from('mortality_recs')
            ->add_column('Actions', "<div class=\"text-center\"><a class=\"tip\" title='" . $this->lang->line('edit_mortality_rec') . "' href='" . admin_url('mortality_recs/edit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . $this->lang->line('delete_mortality_rec') . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('mortality_recs/delete/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", 'id');
        //->unset_column('id');
        echo $this->datatables->generate();
    }

    public function getLogoList()
    {
        $this->load->helper('directory');
        $dirname = 'assets/uploads/logos';
        $ext     = ['jpg', 'png', 'jpeg', 'gif'];
        $files   = [];
        if ($handle = opendir($dirname)) {
            while (false !== ($file = readdir($handle))) {
                for ($i = 0; $i < sizeof($ext); $i++) {
                    if (stristr($file, '.' . $ext[$i])) { //NOT case sensitive: OK with JpeG, JPG, ecc.
                        $files[] = $file;
                    }
                }
            }
            closedir($handle);
        }
        sort($files);
        return $files;
    }

    public function index($action = null)
    {
        $this->sma->checkPermissions();

        $this->data['error']  = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['action'] = $action;
        $bc                   = [['link' => base_url(), 'page' => lang('home')], ['link' => '#', 'page' => lang('mortality_recs')]];
        $meta                 = ['page_title' => lang('mortality_recs'), 'bc' => $bc];
        $this->page_construct('mortality_recs/index', $meta, $this->data);
    }

    public function suggestions($term = null, $limit = null)
    {
        $this->sma->checkPermissions('index');

        if ($this->input->get('term')) {
            $term = $this->input->get('term', true);
        }
        $term            = addslashes($term);
        $limit           = $this->input->get('limit', true);
        $rows['results'] = $this->mortality_recs_model->getMortality_recSuggestions($term, $limit);
        $this->sma->send_json($rows);
    }
    
    public function modal_view($id = null)
    {
        $this->sma->checkPermissions('index', true);

        $pr_details = $this->mortality_recs_model->getMortality_recByID($id);
        
        if (!$id || !$pr_details) {
            $this->session->set_flashdata('error', lang('mortality_rec_not_found'));
            $this->sma->md();
        }
        
        $this->data['mortality_rec']     = $pr_details;

        $this->load->view($this->theme . 'mortality_recs/modal_view', $this->data);
    }
    
    public function pdf($id = null, $view = null)
    {
        $this->sma->checkPermissions('index');

        $pr_details = $this->mortality_recs_model->getMortality_recByID($id);
        if (!$id || !$pr_details) {
            $this->session->set_flashdata('error', lang('prduct_not_found'));
            redirect($_SERVER['HTTP_REFERER']);
        }
        
        $this->data['mortality_rec'] = $pr_details;

        $name = lang('mortality_rec') . '_' . $pr_details->id  . '.pdf';
        if ($view) {
            $this->load->view($this->theme . 'mortality_recs/pdf', $this->data);
        } else {
            $html = $this->load->view($this->theme . 'mortality_recs/pdf', $this->data, true);
            if (!$this->Settings->barcode_img) {
                $html = preg_replace("'\<\?xml(.*)\?\>'", '', $html);
            }
            $this->sma->generate_pdf($html, $name);
        }
    }

}
