<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Ben_recs extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }
        if (!$this->Owner) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }
        $this->load->library('upload');
        $this->lang->admin_load('ben_recs', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('ben_recs_model');
    }

    public function add()
    {
        $this->sma->checkPermissions(false, true);

        if ($this->form_validation->run('ben_recs/add') == true) {
            $data = [
                'ref_no'  => $this->input->post('ref_no'),
                'ben_no'  => $this->input->post('ben_no'),
                'breeding_start_date'  => $this->input->post('breeding_start_date'),
                'breeding_end_date'  => $this->input->post('breeding_end_date'),
                'male_animal_id'  => $this->input->post('male_animal_id'),
                'female_animal_id'  => $this->input->post('female_animal_id'),
                'description' => $this->input->post('description'),
            ];
            
            if ($_FILES['image']['size'] > 0) {
                $config['upload_path']   = 'assets/uploads/';
                $config['allowed_types'] = 'gif|jpg|png'; 
                 $config['max_size']      = 1024; 
                //  $config['max_width']     = 1024; 
                //  $config['max_height']    = 768;  
                $config['overwrite']     = false;
                $config['max_filename']  = 25;
                $config['encrypt_name']  = true;
                // $this->load->library('upload', $config);
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('image')) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect('ben_recs/index');
                }
                $photo         = $this->upload->file_name;
                $data['image'] = $photo;
                
            }
        } elseif ($this->input->post('add_ben_rec')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('ben_recs');
        }

        if ($this->form_validation->run() == true && $this->ben_recs_model->addBen_rec($data)) {
            $this->session->set_flashdata('message', $this->lang->line('ben_rec_added'));
            admin_redirect('ben_recs');
        } else {
            $this->data['logos']    = $this->getLogoList();
            $this->data['error']    = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'ben_recs/add', $this->data);
        }
    }

    public function ben_rec_actions()
    {
        if (!$this->Owner && !$this->GP['bulk_actions']) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }

        $this->form_validation->set_rules('form_action', lang('form_action'), 'required');

        if ($this->form_validation->run() == true) {
            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    $this->sma->checkPermissions('delete');
                    $error = false;
                    foreach ($_POST['val'] as $id) {
                        if (!$this->ben_recs_model->deleteBen_rec($id)) {
                            $error = true;
                        }
                    }
                    if ($error) {
                        $this->session->set_flashdata('warning', lang('ben_recs_x_deleted_have_sales'));
                    } else {
                        $this->session->set_flashdata('message', $this->lang->line('ben_recs_deleted'));
                    }
                    redirect($_SERVER['HTTP_REFERER']);
                }

                if ($this->input->post('form_action') == 'export_excel') {
                    $this->load->library('excel');
                    $this->excel->setActiveSheetIndex(0);
                    $this->excel->getActiveSheet()->setTitle(lang('ben_recs'));
                        $this->excel->getActiveSheet()->SetCellValue('A1', lang('ref_no'));
                        $this->excel->getActiveSheet()->SetCellValue('B1', lang('ben_no'));
                        $this->excel->getActiveSheet()->SetCellValue('C1', lang('breeding_start_date'));
                        $this->excel->getActiveSheet()->SetCellValue('D1', lang('breeding_end_date'));
                        $this->excel->getActiveSheet()->SetCellValue('E1', lang('male_animal_id'));
                        $this->excel->getActiveSheet()->SetCellValue('F1', lang('female_animal_id'));
                        $this->excel->getActiveSheet()->SetCellValue('G1', lang('description'));
                    
                    

                    $row = 2;
                    foreach ($_POST['val'] as $id) {
                        $obj = $this->ben_recs_model->getBen_recByID($id);
                        $this->excel->getActiveSheet()->SetCellValue('A' . $row, $obj->ref_no);
                        $this->excel->getActiveSheet()->SetCellValue('B' . $row, $obj->ben_no);
                        $this->excel->getActiveSheet()->SetCellValue('C' . $row, $obj->breeding_start_date);
                        $this->excel->getActiveSheet()->SetCellValue('D' . $row, $obj->breeding_end_date);
                        $this->excel->getActiveSheet()->SetCellValue('E' . $row, $obj->male_animal_id);
                        $this->excel->getActiveSheet()->SetCellValue('F' . $row, $obj->female_animal_id);
                        $this->excel->getActiveSheet()->SetCellValue('G' . $row, $obj->description);
                        $row++;
                    }

                    $this->excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
                    $this->excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
                    $this->excel->getDefaultStyle()->getAlignment()->setVertical('center');
                    $filename = 'ben_recs_' . date('Y_m_d_H_i_s');
                    $this->load->helper('excel');
                    create_excel($this->excel, $filename);
                }
            } else {
                $this->session->set_flashdata('error', $this->lang->line('no_ben_rec_selected'));
                redirect($_SERVER['HTTP_REFERER']);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

    public function delete($id = null)
    {
        $this->sma->checkPermissions(null, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }
        if (!$id) {
            $this->sma->send_json(['error' => 1, 'msg' => lang('id_not_found')]);
        }

        if ($this->ben_recs_model->deleteBen_rec($id)) {
            $this->sma->send_json(['error' => 0, 'msg' => lang('ben_rec_deleted')]);
        } else {
            $this->sma->send_json(['error' => 1, 'msg' => lang('ben_rec_x_deleted_have_sales')]);
        }
    }

    public function edit($id = null)
    {
        $this->sma->checkPermissions(false, true);

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $ben_rec_details = $this->ben_recs_model->getBen_recByID($id);

        if ($this->form_validation->run('ben_recs/add') == true) {
            
            $data = [
                'ref_no'  => $this->input->post('ref_no'),
                'ben_no'  => $this->input->post('ben_no'),
                'breeding_start_date'  => $this->input->post('breeding_start_date'),
                'breeding_end_date'  => $this->input->post('breeding_end_date'),
                'male_animal_id'  => $this->input->post('male_animal_id'),
                'female_animal_id'  => $this->input->post('female_animal_id'),
                'description' => $this->input->post('description'),
            ];
            
            if ($_FILES['image']['size'] > 0) {
                $config['upload_path']   = 'assets/uploads/';
                $config['allowed_types'] = 'gif|jpg|png'; 
                 $config['max_size']      = 1024; 
                //  $config['max_width']     = 1024; 
                //  $config['max_height']    = 768;  
                // $config['overwrite']     = true;
                // $config['file_name'] = $ben_rec_details->image;
                
                $config['overwrite']     = false;
                $config['max_filename']  = 25;
                $config['encrypt_name']  = true;
                
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('image')) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    admin_redirect('ben_recs/index');
                }
                $photo         = $this->upload->file_name;
                $data['image'] = $photo;
                
            }
            
        } elseif ($this->input->post('edit_ben_rec')) {
            $this->session->set_flashdata('error', validation_errors());
            admin_redirect('ben_recs');
        }

        if ($this->form_validation->run() == true && $this->ben_recs_model->updateBen_rec($id, $data)) {
            $this->session->set_flashdata('message', $this->lang->line('ben_rec_updated'));
            admin_redirect('ben_recs');
        } else {
            $this->data['ben_rec']   = $ben_rec_details;
            $this->data['error']    = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['logos']    = $this->getLogoList();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme . 'ben_recs/edit', $this->data);
        }
    }

    public function getBen_rec($id = null)
    {
        $this->sma->checkPermissions('index');

        $row = $this->ben_recs_model->getBen_recByID($id);
        $this->sma->send_json([['id' => $row->id, 'text' => $row->name]]);
    }

    public function getBen_recs()
    {
        $this->sma->checkPermissions('index');

        $this->load->library('datatables');
        $this->datatables
            ->select('id, image, ref_no, ben_no, breeding_start_date, breeding_end_date, male_animal_id, female_animal_id')
            ->from('ben_recs')
            ->add_column('Actions', "<div class=\"text-center\"><a class=\"tip\" title='" . $this->lang->line('edit_ben_rec') . "' href='" . admin_url('ben_recs/edit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> <a href='#' class='tip po' title='<b>" . $this->lang->line('delete_ben_rec') . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('ben_recs/delete/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i></a></div>", 'id');
        //->unset_column('id');
        echo $this->datatables->generate();
    }

    public function getLogoList()
    {
        $this->load->helper('directory');
        $dirname = 'assets/uploads/logos';
        $ext     = ['jpg', 'png', 'jpeg', 'gif'];
        $files   = [];
        if ($handle = opendir($dirname)) {
            while (false !== ($file = readdir($handle))) {
                for ($i = 0; $i < sizeof($ext); $i++) {
                    if (stristr($file, '.' . $ext[$i])) { //NOT case sensitive: OK with JpeG, JPG, ecc.
                        $files[] = $file;
                    }
                }
            }
            closedir($handle);
        }
        sort($files);
        return $files;
    }

    public function index($action = null)
    {
        $this->sma->checkPermissions();

        $this->data['error']  = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['action'] = $action;
        $bc                   = [['link' => base_url(), 'page' => lang('home')], ['link' => '#', 'page' => lang('ben_recs')]];
        $meta                 = ['page_title' => lang('ben_recs'), 'bc' => $bc];
        $this->page_construct('ben_recs/index', $meta, $this->data);
    }

    public function suggestions($term = null, $limit = null)
    {
        $this->sma->checkPermissions('index');

        if ($this->input->get('term')) {
            $term = $this->input->get('term', true);
        }
        $term            = addslashes($term);
        $limit           = $this->input->get('limit', true);
        $rows['results'] = $this->ben_recs_model->getBen_recSuggestions($term, $limit);
        $this->sma->send_json($rows);
    }
    
    public function modal_view($id = null)
    {
        $this->sma->checkPermissions('index', true);

        $pr_details = $this->ben_recs_model->getBen_recByID($id);
        
        if (!$id || !$pr_details) {
            $this->session->set_flashdata('error', lang('ben_rec_not_found'));
            $this->sma->md();
        }
        
        $this->data['ben_rec']     = $pr_details;

        $this->load->view($this->theme . 'ben_recs/modal_view', $this->data);
    }
    
    public function pdf($id = null, $view = null)
    {
        $this->sma->checkPermissions('index');

        $pr_details = $this->ben_recs_model->getBen_recByID($id);
        if (!$id || !$pr_details) {
            $this->session->set_flashdata('error', lang('prduct_not_found'));
            redirect($_SERVER['HTTP_REFERER']);
        }
        
        $this->data['ben_rec'] = $pr_details;

        $name = lang('ben_rec') . '_' . $pr_details->id  . '.pdf';
        if ($view) {
            $this->load->view($this->theme . 'ben_recs/pdf', $this->data);
        } else {
            $html = $this->load->view($this->theme . 'ben_recs/pdf', $this->data, true);
            if (!$this->Settings->barcode_img) {
                $html = preg_replace("'\<\?xml(.*)\?\>'", '', $html);
            }
            $this->sma->generate_pdf($html, $name);
        }
    }

}
